﻿using System.Text.RegularExpressions;

Console.Write(@"
.____                 _________________                     ___________     _________              __   
|    |    ____   ____ \_____  \_   ___ \  ______  _  _______\__    ___/___ /   _____/ ____________/  |_ 
|    |   /  _ \ / ___\ /  ____/    \  \/ /  _ \ \/ \/ /  ___/ |    | /  _ \\_____  \ /  _ \_  __ \   __\
|    |__(  <_> ) /_/  >       \     \___(  <_> )     /\___ \  |    |(  <_> )        (  <_> )  | \/|  |  
|_______ \____/\___  /\_______ \______  /\____/ \/\_//____  > |____| \____/_______  /\____/|__|   |__|  
        \/    /_____/         \/      \/                  \/                      \/                    

Hello, Paul!

");

if (args.Length < 1)
{
    Console.WriteLine("Missing logfile argument");
    Console.WriteLine("Press enter to close");
    Console.ReadLine();
    return;
}

var fileInfo = new FileInfo(args[0]);

if (!fileInfo.Exists)
{
    Console.WriteLine("Logfile does not exists");
    Console.WriteLine("Press enter to close");
    Console.ReadLine();
    return;
}

var cowsToSortFile = new FileInfo(args[0] + ".cowstosort.txt");

if (cowsToSortFile.Exists)
{
    Console.WriteLine("{0} already exists", cowsToSortFile.FullName);
    Console.WriteLine("Press enter to continue");
    Console.ReadLine();
}

{
    using var writeStream = cowsToSortFile.OpenWrite();
    using var writer = new StreamWriter(writeStream);

    using var stream = fileInfo.OpenRead();
    using var reader = new StreamReader(stream);

    string line;

    List<CowToSort> processingCows = new();

    bool TryParseDateTimeColumns(string date, string time, out DateTime result)
    {
        return DateTime.TryParse($"{date} {time}", out result);
    }

    while ((line = reader.ReadLine()) != null)
    {
        var columns = line.Split("|", StringSplitOptions.TrimEntries);

        if (columns.Length != 4)
            continue;

        if (columns[2] == "Cow added to sort list")
        {
            if (ulong.TryParse(columns[3], out var regId))
            {
                if (processingCows.Any(x => x.RFID == regId && x.EndTime == null))
                {
                    Console.WriteLine("ERR: Cow with RFID {0} was already added form line {1}", regId, line);
                }
                else
                {
                    if (TryParseDateTimeColumns(columns[0], columns[1], out var startTime))
                    {
                        processingCows.Add(new CowToSort{ RFID = regId, StartTime = startTime });
                    }
                    else
                    {
                        Console.WriteLine("ERR: Could not parse date form line {0}", line);
                    }
                }
            }
            else
            {
                Console.WriteLine("ERR: Could not parse RFID in line: " + line);
            }
        }

        if (columns[2] == "Cow removed from sort list")
        {
            if (ulong.TryParse(columns[3], out var regId))
            {
                if (!processingCows.Any(x => x.RFID == regId))
                {
                    Console.WriteLine("ERR: Cow with RFID {0} was not seen before from line {1}", regId, line);
                }
                else
                {
                    if (TryParseDateTimeColumns(columns[0], columns[1], out var endTime))
                    {
                        var cowToSort = processingCows.Last(x => x.RFID == regId);
                        cowToSort.EndTime = endTime;
                    }
                    else
                    {
                        Console.WriteLine("ERR: Could not parse date form line {0}", line);
                    }
                }
            }
            else
            {
                Console.WriteLine("ERR: Could not parse RFID in line: " + line);
            }
        }
    }

    foreach(var cowToSort in processingCows)
    {
        writer.WriteLine("{0} | {1} | {2}", cowToSort.RFID, cowToSort.StartTime?.ToString("yyyy-MM-dd HH:mm:ss.fff"), cowToSort.EndTime?.ToString("yyyy-MM-dd HH:mm:ss.fff"));
    }
}

Console.WriteLine("Done, result is in {0}", cowsToSortFile.FullName);
Console.WriteLine("Press enter to close");
Console.ReadLine();

class CowToSort
{
    public ulong RFID { get; set; }
    public DateTime? StartTime { get; set; }
    public DateTime? EndTime { get; set; }
}